# The Ancient Near East: Historical and Cultural Introduction

[TOC]



圣经在现代前的评论家认为是宗教文本，根据现代考古学，实际上圣经不单单是一个独立的创作。美索不达米亚在希腊语中的意思是"(两)河中间的的地方"，即幼发拉底河（Euphrates）和底格里斯河（Tigris）之间。在古代这一地区的主要语言是苏美尔语（**Sumerian**）和阿卡德语（**Akkadian**）。这两种语言都是楔形文字，但在语言学上它们非常的不同。

<u>苏美尔语不属于现代我们知道的任何语系</u>，最古老的文字，阿卡德语属于东方闪米特语. 我们熟知的中东语系的关系如下：

---

- 苏美尔语
- Proto-Semitic
  - 西闪米特语
    - 阿拉伯语
    - 希伯来语
    - 阿拉姆语 (Aramaic)
  - 东闪米特语
    - 阿卡德语
      - 亚述语方言 (北部)
      - 巴比伦语方言 (南部)

---



## 1. 早期时代

- 公元前3200年，最早的苏美尔语书写文本，这一文本内容是财务交易。
- 早期王朝时期（Early Dynastic Period）公元前2800—2350。当时的文本包括经济文本，智慧书（Instruction of Shuruppak）和皇家铭文（Royal Inscriptions）。此时书写工具开始进步手写笔不在圆形而是楔形。



## 2. 阿卡德帝国和乌尔三世王朝

- 阿卡德帝国（美索不达米亚北部，公元前24/23世纪建立）
  - 建立者：Sargon （四方之王）
  - 首都位于美索不达米亚北部的阿卡德
  - 中央集权，统一的军队度量衡，年号等等
  - 开始使用阿卡德文作为官方语言
  - 全盛时期统一美索不达米亚
  - 王国君主：Sharkali-Sharri（意为 King of all kings）
- 乌尔三世王朝（美索不达米亚南部，公元前21世纪建立）
  - 创立者：Ur-Nammu （苏美尔和阿卡德之王）
  - 首都是乌尔城，建造了金字塔（Ziggurat），官方语言苏美尔语
  - 有大量记录帝国生活文本保留，有书写员学校
  - 新的文学体裁包括皇家赞美诗和民法刑法
  - 公元前2004年覆灭，被 Elam王国和一支亚摩利亚人的部落消灭。



## 3. 古巴比伦时期和古亚述时期

这一时期大约处于公元前20世纪到公元前16世纪。北方的是亚述方言的阿卡德语，南方是巴比伦方言的阿卡德语。此时苏美尔语不再是常用口语，只作为文学语言。此时的政治权利开始分散，类似于中国的春秋战国时期，诸侯混战。

此时美索不达米亚地区有游牧民族亚摩利亚人（Amorite）及其文化的渗透。亚摩利亚人最大的城邦是马里（Mari），位于幼发拉底河河畔。在这里出土了一个宫殿，有著名的先知文化。

- 古巴比伦（美索不达米亚南部）
  - 马里：亚摩利亚人城邦
  - Isin： Laws of King Ishtar （1934-1924BCE）
  - Larsa
  - Babylon：亚摩利人，汉谟拉比（1763BCE统一了古巴比伦和亚述）
  - Eshruma
- 古亚述（美索不达米亚北部）
  - 亚述王国：美索不达米亚北方最大城市，贸易发达，有最早的银行系统，和远在 Anatolia 的人通商。

汉谟拉比死后，古巴比伦帝国迅速衰退。公元前1595年，赫梯国王 Mursili 一世击败了古巴比伦帝国。不过他们不久后就撤离了巴比伦，留下了混乱的地方。

## 4. Kassite 时期和中亚述时期

- Kassites：（美索不达米亚南部）（1595-1155BCE）
  - 首都位于巴比伦
  - 信息很少，不过他们很快融入了巴比伦社会，使用巴比伦人的阿卡德文
  - 此时抄写员不再使用苏美尔文
  - 著名诗歌 Ludlul bēl nēmeqi （I will praise the lord of wisdom）和圣经的约伯书类似。
- 中亚述王国（美索不达米亚北部）
  - 首都在 Assur，有中亚述法律
  - 以亚述年鉴（Assyrian Annals）代表皇家铭文开始增加大量的年度报告，用以表彰国王的功绩



## 5. 亚述帝国

亚述帝国出现在公元前934年到公元前610年，他们统一了新月沃土和一部分埃及。此时，以色列和美索不达米亚地区有了历史连接。亚述帝国有如下几位有名的国王

1. Shalmaneser III (859–824 BCE) 在他的铭文中提到了两位以色列王 Ahab 和 Jehu 是他的对手
2. Tiglath-Pileser III (744–727 BCE) 他占领了大量的以色列地区，并接受了犹大国王 Ahaz 的投降。
3. Shalmeneser V (727–722 BCE) 对以色列王国实施了最后的围困
4. Sargon II (722–705 BCE) 摧毁了以色列王国并驱逐了当地人。
5. Sennacherib (705–681 BCE) 发动了著名的犹大运动，最终耶路撒冷被保留下来，但 Lachish 被摧毁。
6. ==King Ashurbanipal== 虽然没有和以色列有直接联系，但是他在位时在尼尼微建立一个非常大的图书馆，有3万多的陶片板。这一时期是文化的黄金时代。

Ashurbanipal 死后（大约在公元前639-620年间），亚述开始衰落，原因还不清楚。但是之后在公元前605年这一地区被他们南边的对手巴比伦王朝统一。



## 6. 巴比伦帝国

有关于巴比伦帝国的历史文档比较少，他们只用皇家铭文记录建设而不是军事行动，有巴比伦编年史（Babylonian Chronicles）。以下是几个著名的国王：

- King Nabopolassar（公元前7世纪），他可能是一名将军而非皇室成员，他在北部攻击了亚述中心城市
- Nebuchadnezzar II (604-562 BCE) 在 Carchemish 战役中获胜，确立了他对巴比伦的统治。他在位期间大兴土木，建造了神庙和金字塔。在圣经故事中，他是犹大和耶路撒冷毁灭的罪魁祸首。
- Nabonidus (556-539 BCE) 是最后的国王，他被波斯帝国的大流士大帝在公元前539年击败。



whzecomjm
20190623

